#include "hal_base.h"
#include "hal_lvd.h"
#include "hal_irq.h"

uint8_t loop;			// ִдͳ
hal_status_t status;	// պ״̬

/* жϷLVDж־ͳ */
void isr(void) interrupt
{
	if (irq_get_it_status(LVDIE_IT) && irq_get_flag_status(LVDIE_IT)) {
		irq_clear_flag_status(LVDIE_IT);
		loop++;
	}
}

void main() 
{
	// RAMʼ
	ram_clear();
	// ι
	CLRWDT();
	// clockʼѡHRC,Ƶʹclock 
	status = clock_init(CLOCK_SRC_HRC, CLOCK_DIV_1, DISABLE);

	// ʹж
	IRQ_GIE_CFG(1);
	// ʹLVDж
	irq_config(LVDIE_IT, ENABLE);

	// LVDѹֵѡ2.9V˫ؾɴLVDж
	lvd_init(LVD_VOL_SEL_2_9, LVD_TRIGGER_RISING_FALLING);

	while (1) {
		// ι
		CLRWDT();
	}
}